/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreePath;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

final class AddCastFix
extends JavaFix {
    private JavaSource js;
    private String treeName;
    private String type;
    private final TypeMirrorHandle<TypeMirror> targetType;
    private final TreePathHandle idealTypeTree;

    public AddCastFix(CompilationInfo info, TreePath expression, TreePath idealTypeTree, TypeMirror targetType) {
        super(info, expression);
        this.idealTypeTree = idealTypeTree != null ? TreePathHandle.create((TreePath)idealTypeTree, (CompilationInfo)info) : null;
        this.targetType = TypeMirrorHandle.create((TypeMirror)targetType);
        this.treeName = Utilities.shortDisplayName(info, (ExpressionTree)expression.getLeaf());
        this.type = org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)targetType, (boolean)false).toString();
    }

    protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
        boolean wrapWithBrackets;
        TypeMirror resolvedTargetType = this.targetType.resolve((CompilationInfo)ctx.getWorkingCopy());
        if (resolvedTargetType == null) {
            return;
        }
        TreePath resolvedIdealTypeTree = this.idealTypeTree != null ? this.idealTypeTree.resolve((CompilationInfo)ctx.getWorkingCopy()) : null;
        TreeMaker make = ctx.getWorkingCopy().getTreeMaker();
        ExpressionTree toCast = (ExpressionTree)ctx.getPath().getLeaf();
        Class<? extends Tree> interf = toCast.getKind().asInterface();
        boolean bl = wrapWithBrackets = interf == BinaryTree.class || interf == ConditionalExpressionTree.class;
        if (wrapWithBrackets) {
            toCast = make.Parenthesized(toCast);
        }
        TypeCastTree cast = make.TypeCast(resolvedIdealTypeTree != null ? resolvedIdealTypeTree.getLeaf() : make.Type(resolvedTargetType), toCast);
        ctx.getWorkingCopy().rewrite(ctx.getPath().getLeaf(), (Tree)cast);
    }

    public String getText() {
        return NbBundle.getMessage(AddCastFix.class, (String)"LBL_FIX_Add_Cast", (Object)this.treeName, (Object)this.type);
    }

    public String toDebugString() {
        return "[AddCastFix:" + this.treeName + ":" + this.type + "]";
    }
}

